//	TorusGamesInit.c
//
//	© 2021 by Jeff Weeks
//	See TermsOfUse.txt

#include "TorusGames-Common.h"
#include "GeometryGamesUtilities-Common.h"
#include "GeometryGamesLocalization.h"
#include "GeometryGamesMatrix44.h"


//	How big is the hand cursor?
#define HAND_SIZE	0.1


//	Languages for inclusion on the Language menu
const Char16		gLanguages[][3]	= {u"de", u"el", u"en", u"es", u"fi", u"fr", u"it", u"ja", u"ko", u"nl", u"pt", u"ru", u"vi", u"zs", u"zt"};
const unsigned int	gNumLanguages	= BUFFER_LENGTH(gLanguages);


const Char16 *GetLanguageFileBaseName(void)
{
	return u"TorusGames";
}

unsigned int SizeOfModelData(void)
{
	return sizeof(ModelData);
}

void SetUpModelData(ModelData *md)
{
	//	No changes yet.
	md->itsChangeCount = 0;

	//	Scrolling position
	md->itsOffset.itsH		= 0.0;
	md->itsOffset.itsV		= 0.0;
	md->itsOffset.itsFlip	= false;

	//	Options
	md->itsGame						= GameNone;
	md->itsTopology					= Topology2DTorus;
	md->itsViewType					= ViewBasicLarge;
	md->its2DViewMagFactor			= 1.0;
	md->itsDesired2DViewMagFactor	= 1.0;
	md->itsDesiredViewType			= ViewBasicLarge;	//	ignored
#ifdef GAME_CONTENT_FOR_SCREENSHOT
	md->itsHumanVsComputer			= false;
#else
	md->itsHumanVsComputer			= true;
#endif
	md->itsDifficultyLevel			= 1;	//	medium difficulty
#ifdef TORUS_GAMES_FOR_TALK
	md->itsShowGlideAxes			= false;
#else
	md->itsShowGlideAxes			= true;
#endif

	//	Win tracking
	md->itsGameIsOver	= false;
	md->itsFlashFlag	= false;
	
	//	No drag in progress
	md->itsDragBeganTime		= 0.0;
	md->itsPreviousDragTime		= 0.0;
	md->itsPreviousDragPoint[0]	= 0.0;
	md->itsPreviousDragPoint[1]	= 0.0;
	md->its3DDragType			= DragNone;
	
	//	No 3D rotation in progress
	md->its3DRotationalVelocity	= (Velocity)VELOCITY_ZERO;

	//	No 3D scroll in progress
	md->its3DScrollAxisIsKnown		= false;
	md->its3DScrollAxis				= 0;
	md->its3DProjectedScrollAxis[0]	= 0.0;
	md->its3DProjectedScrollAxis[1]	= 0.0;
	md->its3DScrollFactor			= 1.0;
	md->its3DScrollSpeed			= 0.0;

	//	2D hand status
	md->its2DHandStatus				= HandNone;
	md->its2DHandPlacement.itsH		= 0.0;
	md->its2DHandPlacement.itsV		= 0.0;
	md->its2DHandPlacement.itsFlip	= false;
	md->its2DHandPlacement.itsAngle	= 0.0;
	md->its2DHandPlacement.itsSizeH	= HAND_SIZE;
	md->its2DHandPlacement.itsSizeV	= HAND_SIZE;
	
#ifdef TORUS_GAMES_2D_MOUSE_INTERFACE
	//	2D double-click testing
	md->its2DPreviousClickWasDoubleClickEligible	= false;
	md->its2DDoubleClickFlag						= false;
	md->its2DPrevClickPlacement						= md->its2DHandPlacement;
#endif
	
	//	No coasting in progress
	md->itsCoastingStatus	= CoastingNone;
	
	//	In particular, no 2D coasting in progress
	md->its2DCoastingVelocity[0]	= 0.0;
	md->its2DCoastingVelocity[1]	= 0.0;

	//	The macOS version always presents the Chinese poems in column format.
	//	The  iOS  version will report which layout it prefers.
	md->itsChinesePoemsWantColumnFormatting	= true;	//	default for macOS

	//	Scrolling position
	Matrix44Identity(md->its3DTilingIntoFrameCell);
	md->its3DFrameCellIntoWorld = (Isometry)IDENTITY_ISOMETRY;
	
	//	Aperture
	md->its3DDesiredAperture	= 0.0;
	md->its3DCurrentAperture	= 0.0;
	
	//	Drag message
	md->itsDragMessage.itsMessage	= NULL;
	md->itsDragMessage.itsTitle		= NULL;
	
	//	Simulation status
	md->itsSimulationStatus			= SimulationNone;
	md->itsSimulationElapsedTime	= 0.0;
	md->itsSimulationDeltaTime		= 0.0;
	
	//	Progress meter
	md->itsProgressMeterIsActive	= false;
	md->itsProgressMeter			= 0.0;

	//	Accumulated 3D drag
	md->itsAccumulated3DDragMotion[0] = 0.0;
	md->itsAccumulated3DDragMotion[1] = 0.0;
	
	//	Function pointers
	ClearFunctionPointers(md);

	//	Initialize the random number generator.
	RandomInit();
}

void ShutDownModelData(ModelData *md)
{
	//	The caller should have already switched to GameNone,
	//	to let the previously active game free its game-specific memory.
	if (md->itsGame != GameNone)
		GeometryGamesErrorMessage(u"ShutDownModelData() called when itsGame ≠ GameNone", u"Internal Error");

	//	If the null game held any allocated memory we'd free it here, but it doesn't.
}


void ClearFunctionPointers(ModelData *md)
{
	md->itsGameShutDown					= NULL;
	md->itsGameReset					= NULL;
	md->itsGameHumanVsComputerChanged	= NULL;
	md->itsGame2DHandMoved				= NULL;
	md->itsGame2DDragBegin				= NULL;
	md->itsGame2DDragObject				= NULL;
	md->itsGame2DDragEnd				= NULL;
	md->itsGame3DDragBegin				= NULL;
	md->itsGame3DDragObject				= NULL;
	md->itsGame3DDragEnd				= NULL;
	md->itsGame3DGridSize				= NULL;
	md->itsGameCharacterInput			= NULL;
	md->itsGameSimulationUpdate			= NULL;
	md->itsGameRefreshMessage			= NULL;
}
